%------------------------------------------------------------------------------
% File     : GRA074^2 : TPTP v7.4.0. Released v3.6.0.
% Domain   : Graph Theory
% Problem  : R(5,15) > 256
% Version  : Especial.
% English  :

% Refs     : [Rad06] Radziszowski (2006), Small Ramsey Numbers
%          : [Bro08] Brown (2008), Email to G. Sutcliffe
% Source   : [Bro08]
% Names    :

% Status   : Theorem
% Rating   : 1.00 v3.7.0
% Syntax   : Number of formulae    :    1 (   0 unit;   0 type;   0 defn)
%            Number of atoms       :  811 (   0 equality; 811 variable)
%            Maximal formula depth :  245 ( 245 average)
%            Number of connectives : 1032 ( 222   ~; 113   |; 230   &; 464   @)
%                                         (   0 <=>;   3  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :  146 ( 146   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :    1 (   0   :;   0   =)
%            Number of variables   :   41 (   0 sgn;  40   !;   1   ?;   0   ^)
%                                         (  41   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_NEQ_NAR

% Comments : If a type alpha has exactly n elements, then we can prove
%            R(k,l) > n by finding a graph (symmetric binary relation) on type
%            alpha with no k-cliques and no l-independent sets. Likewise, we
%            can prove R(k,l) <= n by proving every graph (symmetric binary
%            relation) on alpha must have a k-clique or l-independent set.
%            There is one type with 4 elements: o > o. There are two types
%            with 16 elements: o > o > o and (o > o) > o. There are two types
%            with 256 elements: o > o > o > o and o > (o > o) > o.  This means
%            we always have two formulations of R(k,l) >/<= 16 and two
%            formulations of R(k,l) >/<= 256.
%          : 
%------------------------------------------------------------------------------
thf(ramsey_l_5_15_256a,conjecture,(
    ? [G: ( $o > ( $o > $o ) > $o ) > ( $o > ( $o > $o ) > $o ) > $o] :
      ( ! [Xx: $o > ( $o > $o ) > $o,Xy: $o > ( $o > $o ) > $o] :
          ( ( G @ Xx @ Xy )
         => ( G @ Xy @ Xx ) )
      & ! [Xx0: $o > ( $o > $o ) > $o,Xx1: $o > ( $o > $o ) > $o,Xx2: $o > ( $o > $o ) > $o,Xx3: $o > ( $o > $o ) > $o,Xx4: $o > ( $o > $o ) > $o,Xp0: ( $o > ( $o > $o ) > $o ) > $o,Xp1: ( $o > ( $o > $o ) > $o ) > $o,Xp2: ( $o > ( $o > $o ) > $o ) > $o,Xp3: ( $o > ( $o > $o ) > $o ) > $o] :
          ( ( ( Xp0 @ Xx0 )
            & ~ ( Xp0 @ Xx1 )
            & ~ ( Xp0 @ Xx2 )
            & ~ ( Xp0 @ Xx3 )
            & ~ ( Xp0 @ Xx4 )
            & ~ ( Xp1 @ Xx0 )
            & ( Xp1 @ Xx1 )
            & ~ ( Xp1 @ Xx2 )
            & ~ ( Xp1 @ Xx3 )
            & ~ ( Xp1 @ Xx4 )
            & ~ ( Xp2 @ Xx0 )
            & ~ ( Xp2 @ Xx1 )
            & ( Xp2 @ Xx2 )
            & ~ ( Xp2 @ Xx3 )
            & ~ ( Xp2 @ Xx4 )
            & ~ ( Xp3 @ Xx0 )
            & ~ ( Xp3 @ Xx1 )
            & ~ ( Xp3 @ Xx2 )
            & ( Xp3 @ Xx3 )
            & ~ ( Xp3 @ Xx4 ) )
         => ( ~ ( G @ Xx1 @ Xx0 )
            | ~ ( G @ Xx2 @ Xx0 )
            | ~ ( G @ Xx2 @ Xx1 )
            | ~ ( G @ Xx3 @ Xx0 )
            | ~ ( G @ Xx3 @ Xx1 )
            | ~ ( G @ Xx3 @ Xx2 )
            | ~ ( G @ Xx4 @ Xx0 )
            | ~ ( G @ Xx4 @ Xx1 )
            | ~ ( G @ Xx4 @ Xx2 )
            | ~ ( G @ Xx4 @ Xx3 ) ) )
      & ! [Xx0: $o > ( $o > $o ) > $o,Xx1: $o > ( $o > $o ) > $o,Xx2: $o > ( $o > $o ) > $o,Xx3: $o > ( $o > $o ) > $o,Xx4: $o > ( $o > $o ) > $o,Xx5: $o > ( $o > $o ) > $o,Xx6: $o > ( $o > $o ) > $o,Xx7: $o > ( $o > $o ) > $o,Xx8: $o > ( $o > $o ) > $o,Xx9: $o > ( $o > $o ) > $o,Xx10: $o > ( $o > $o ) > $o,Xx11: $o > ( $o > $o ) > $o,Xx12: $o > ( $o > $o ) > $o,Xx13: $o > ( $o > $o ) > $o,Xx14: $o > ( $o > $o ) > $o,Xp0: ( $o > ( $o > $o ) > $o ) > $o,Xp1: ( $o > ( $o > $o ) > $o ) > $o,Xp2: ( $o > ( $o > $o ) > $o ) > $o,Xp3: ( $o > ( $o > $o ) > $o ) > $o,Xp4: ( $o > ( $o > $o ) > $o ) > $o,Xp5: ( $o > ( $o > $o ) > $o ) > $o,Xp6: ( $o > ( $o > $o ) > $o ) > $o,Xp7: ( $o > ( $o > $o ) > $o ) > $o,Xp8: ( $o > ( $o > $o ) > $o ) > $o,Xp9: ( $o > ( $o > $o ) > $o ) > $o,Xp10: ( $o > ( $o > $o ) > $o ) > $o,Xp11: ( $o > ( $o > $o ) > $o ) > $o,Xp12: ( $o > ( $o > $o ) > $o ) > $o,Xp13: ( $o > ( $o > $o ) > $o ) > $o] :
          ( ( ( Xp0 @ Xx0 )
            & ~ ( Xp0 @ Xx1 )
            & ~ ( Xp0 @ Xx2 )
            & ~ ( Xp0 @ Xx3 )
            & ~ ( Xp0 @ Xx4 )
            & ~ ( Xp0 @ Xx5 )
            & ~ ( Xp0 @ Xx6 )
            & ~ ( Xp0 @ Xx7 )
            & ~ ( Xp0 @ Xx8 )
            & ~ ( Xp0 @ Xx9 )
            & ~ ( Xp0 @ Xx10 )
            & ~ ( Xp0 @ Xx11 )
            & ~ ( Xp0 @ Xx12 )
            & ~ ( Xp0 @ Xx13 )
            & ~ ( Xp0 @ Xx14 )
            & ~ ( Xp1 @ Xx0 )
            & ( Xp1 @ Xx1 )
            & ~ ( Xp1 @ Xx2 )
            & ~ ( Xp1 @ Xx3 )
            & ~ ( Xp1 @ Xx4 )
            & ~ ( Xp1 @ Xx5 )
            & ~ ( Xp1 @ Xx6 )
            & ~ ( Xp1 @ Xx7 )
            & ~ ( Xp1 @ Xx8 )
            & ~ ( Xp1 @ Xx9 )
            & ~ ( Xp1 @ Xx10 )
            & ~ ( Xp1 @ Xx11 )
            & ~ ( Xp1 @ Xx12 )
            & ~ ( Xp1 @ Xx13 )
            & ~ ( Xp1 @ Xx14 )
            & ~ ( Xp2 @ Xx0 )
            & ~ ( Xp2 @ Xx1 )
            & ( Xp2 @ Xx2 )
            & ~ ( Xp2 @ Xx3 )
            & ~ ( Xp2 @ Xx4 )
            & ~ ( Xp2 @ Xx5 )
            & ~ ( Xp2 @ Xx6 )
            & ~ ( Xp2 @ Xx7 )
            & ~ ( Xp2 @ Xx8 )
            & ~ ( Xp2 @ Xx9 )
            & ~ ( Xp2 @ Xx10 )
            & ~ ( Xp2 @ Xx11 )
            & ~ ( Xp2 @ Xx12 )
            & ~ ( Xp2 @ Xx13 )
            & ~ ( Xp2 @ Xx14 )
            & ~ ( Xp3 @ Xx0 )
            & ~ ( Xp3 @ Xx1 )
            & ~ ( Xp3 @ Xx2 )
            & ( Xp3 @ Xx3 )
            & ~ ( Xp3 @ Xx4 )
            & ~ ( Xp3 @ Xx5 )
            & ~ ( Xp3 @ Xx6 )
            & ~ ( Xp3 @ Xx7 )
            & ~ ( Xp3 @ Xx8 )
            & ~ ( Xp3 @ Xx9 )
            & ~ ( Xp3 @ Xx10 )
            & ~ ( Xp3 @ Xx11 )
            & ~ ( Xp3 @ Xx12 )
            & ~ ( Xp3 @ Xx13 )
            & ~ ( Xp3 @ Xx14 )
            & ~ ( Xp4 @ Xx0 )
            & ~ ( Xp4 @ Xx1 )
            & ~ ( Xp4 @ Xx2 )
            & ~ ( Xp4 @ Xx3 )
            & ( Xp4 @ Xx4 )
            & ~ ( Xp4 @ Xx5 )
            & ~ ( Xp4 @ Xx6 )
            & ~ ( Xp4 @ Xx7 )
            & ~ ( Xp4 @ Xx8 )
            & ~ ( Xp4 @ Xx9 )
            & ~ ( Xp4 @ Xx10 )
            & ~ ( Xp4 @ Xx11 )
            & ~ ( Xp4 @ Xx12 )
            & ~ ( Xp4 @ Xx13 )
            & ~ ( Xp4 @ Xx14 )
            & ~ ( Xp5 @ Xx0 )
            & ~ ( Xp5 @ Xx1 )
            & ~ ( Xp5 @ Xx2 )
            & ~ ( Xp5 @ Xx3 )
            & ~ ( Xp5 @ Xx4 )
            & ( Xp5 @ Xx5 )
            & ~ ( Xp5 @ Xx6 )
            & ~ ( Xp5 @ Xx7 )
            & ~ ( Xp5 @ Xx8 )
            & ~ ( Xp5 @ Xx9 )
            & ~ ( Xp5 @ Xx10 )
            & ~ ( Xp5 @ Xx11 )
            & ~ ( Xp5 @ Xx12 )
            & ~ ( Xp5 @ Xx13 )
            & ~ ( Xp5 @ Xx14 )
            & ~ ( Xp6 @ Xx0 )
            & ~ ( Xp6 @ Xx1 )
            & ~ ( Xp6 @ Xx2 )
            & ~ ( Xp6 @ Xx3 )
            & ~ ( Xp6 @ Xx4 )
            & ~ ( Xp6 @ Xx5 )
            & ( Xp6 @ Xx6 )
            & ~ ( Xp6 @ Xx7 )
            & ~ ( Xp6 @ Xx8 )
            & ~ ( Xp6 @ Xx9 )
            & ~ ( Xp6 @ Xx10 )
            & ~ ( Xp6 @ Xx11 )
            & ~ ( Xp6 @ Xx12 )
            & ~ ( Xp6 @ Xx13 )
            & ~ ( Xp6 @ Xx14 )
            & ~ ( Xp7 @ Xx0 )
            & ~ ( Xp7 @ Xx1 )
            & ~ ( Xp7 @ Xx2 )
            & ~ ( Xp7 @ Xx3 )
            & ~ ( Xp7 @ Xx4 )
            & ~ ( Xp7 @ Xx5 )
            & ~ ( Xp7 @ Xx6 )
            & ( Xp7 @ Xx7 )
            & ~ ( Xp7 @ Xx8 )
            & ~ ( Xp7 @ Xx9 )
            & ~ ( Xp7 @ Xx10 )
            & ~ ( Xp7 @ Xx11 )
            & ~ ( Xp7 @ Xx12 )
            & ~ ( Xp7 @ Xx13 )
            & ~ ( Xp7 @ Xx14 )
            & ~ ( Xp8 @ Xx0 )
            & ~ ( Xp8 @ Xx1 )
            & ~ ( Xp8 @ Xx2 )
            & ~ ( Xp8 @ Xx3 )
            & ~ ( Xp8 @ Xx4 )
            & ~ ( Xp8 @ Xx5 )
            & ~ ( Xp8 @ Xx6 )
            & ~ ( Xp8 @ Xx7 )
            & ( Xp8 @ Xx8 )
            & ~ ( Xp8 @ Xx9 )
            & ~ ( Xp8 @ Xx10 )
            & ~ ( Xp8 @ Xx11 )
            & ~ ( Xp8 @ Xx12 )
            & ~ ( Xp8 @ Xx13 )
            & ~ ( Xp8 @ Xx14 )
            & ~ ( Xp9 @ Xx0 )
            & ~ ( Xp9 @ Xx1 )
            & ~ ( Xp9 @ Xx2 )
            & ~ ( Xp9 @ Xx3 )
            & ~ ( Xp9 @ Xx4 )
            & ~ ( Xp9 @ Xx5 )
            & ~ ( Xp9 @ Xx6 )
            & ~ ( Xp9 @ Xx7 )
            & ~ ( Xp9 @ Xx8 )
            & ( Xp9 @ Xx9 )
            & ~ ( Xp9 @ Xx10 )
            & ~ ( Xp9 @ Xx11 )
            & ~ ( Xp9 @ Xx12 )
            & ~ ( Xp9 @ Xx13 )
            & ~ ( Xp9 @ Xx14 )
            & ~ ( Xp10 @ Xx0 )
            & ~ ( Xp10 @ Xx1 )
            & ~ ( Xp10 @ Xx2 )
            & ~ ( Xp10 @ Xx3 )
            & ~ ( Xp10 @ Xx4 )
            & ~ ( Xp10 @ Xx5 )
            & ~ ( Xp10 @ Xx6 )
            & ~ ( Xp10 @ Xx7 )
            & ~ ( Xp10 @ Xx8 )
            & ~ ( Xp10 @ Xx9 )
            & ( Xp10 @ Xx10 )
            & ~ ( Xp10 @ Xx11 )
            & ~ ( Xp10 @ Xx12 )
            & ~ ( Xp10 @ Xx13 )
            & ~ ( Xp10 @ Xx14 )
            & ~ ( Xp11 @ Xx0 )
            & ~ ( Xp11 @ Xx1 )
            & ~ ( Xp11 @ Xx2 )
            & ~ ( Xp11 @ Xx3 )
            & ~ ( Xp11 @ Xx4 )
            & ~ ( Xp11 @ Xx5 )
            & ~ ( Xp11 @ Xx6 )
            & ~ ( Xp11 @ Xx7 )
            & ~ ( Xp11 @ Xx8 )
            & ~ ( Xp11 @ Xx9 )
            & ~ ( Xp11 @ Xx10 )
            & ( Xp11 @ Xx11 )
            & ~ ( Xp11 @ Xx12 )
            & ~ ( Xp11 @ Xx13 )
            & ~ ( Xp11 @ Xx14 )
            & ~ ( Xp12 @ Xx0 )
            & ~ ( Xp12 @ Xx1 )
            & ~ ( Xp12 @ Xx2 )
            & ~ ( Xp12 @ Xx3 )
            & ~ ( Xp12 @ Xx4 )
            & ~ ( Xp12 @ Xx5 )
            & ~ ( Xp12 @ Xx6 )
            & ~ ( Xp12 @ Xx7 )
            & ~ ( Xp12 @ Xx8 )
            & ~ ( Xp12 @ Xx9 )
            & ~ ( Xp12 @ Xx10 )
            & ~ ( Xp12 @ Xx11 )
            & ( Xp12 @ Xx12 )
            & ~ ( Xp12 @ Xx13 )
            & ~ ( Xp12 @ Xx14 )
            & ~ ( Xp13 @ Xx0 )
            & ~ ( Xp13 @ Xx1 )
            & ~ ( Xp13 @ Xx2 )
            & ~ ( Xp13 @ Xx3 )
            & ~ ( Xp13 @ Xx4 )
            & ~ ( Xp13 @ Xx5 )
            & ~ ( Xp13 @ Xx6 )
            & ~ ( Xp13 @ Xx7 )
            & ~ ( Xp13 @ Xx8 )
            & ~ ( Xp13 @ Xx9 )
            & ~ ( Xp13 @ Xx10 )
            & ~ ( Xp13 @ Xx11 )
            & ~ ( Xp13 @ Xx12 )
            & ( Xp13 @ Xx13 )
            & ~ ( Xp13 @ Xx14 ) )
         => ( ( G @ Xx1 @ Xx0 )
            | ( G @ Xx2 @ Xx0 )
            | ( G @ Xx2 @ Xx1 )
            | ( G @ Xx3 @ Xx0 )
            | ( G @ Xx3 @ Xx1 )
            | ( G @ Xx3 @ Xx2 )
            | ( G @ Xx4 @ Xx0 )
            | ( G @ Xx4 @ Xx1 )
            | ( G @ Xx4 @ Xx2 )
            | ( G @ Xx4 @ Xx3 )
            | ( G @ Xx5 @ Xx0 )
            | ( G @ Xx5 @ Xx1 )
            | ( G @ Xx5 @ Xx2 )
            | ( G @ Xx5 @ Xx3 )
            | ( G @ Xx5 @ Xx4 )
            | ( G @ Xx6 @ Xx0 )
            | ( G @ Xx6 @ Xx1 )
            | ( G @ Xx6 @ Xx2 )
            | ( G @ Xx6 @ Xx3 )
            | ( G @ Xx6 @ Xx4 )
            | ( G @ Xx6 @ Xx5 )
            | ( G @ Xx7 @ Xx0 )
            | ( G @ Xx7 @ Xx1 )
            | ( G @ Xx7 @ Xx2 )
            | ( G @ Xx7 @ Xx3 )
            | ( G @ Xx7 @ Xx4 )
            | ( G @ Xx7 @ Xx5 )
            | ( G @ Xx7 @ Xx6 )
            | ( G @ Xx8 @ Xx0 )
            | ( G @ Xx8 @ Xx1 )
            | ( G @ Xx8 @ Xx2 )
            | ( G @ Xx8 @ Xx3 )
            | ( G @ Xx8 @ Xx4 )
            | ( G @ Xx8 @ Xx5 )
            | ( G @ Xx8 @ Xx6 )
            | ( G @ Xx8 @ Xx7 )
            | ( G @ Xx9 @ Xx0 )
            | ( G @ Xx9 @ Xx1 )
            | ( G @ Xx9 @ Xx2 )
            | ( G @ Xx9 @ Xx3 )
            | ( G @ Xx9 @ Xx4 )
            | ( G @ Xx9 @ Xx5 )
            | ( G @ Xx9 @ Xx6 )
            | ( G @ Xx9 @ Xx7 )
            | ( G @ Xx9 @ Xx8 )
            | ( G @ Xx10 @ Xx0 )
            | ( G @ Xx10 @ Xx1 )
            | ( G @ Xx10 @ Xx2 )
            | ( G @ Xx10 @ Xx3 )
            | ( G @ Xx10 @ Xx4 )
            | ( G @ Xx10 @ Xx5 )
            | ( G @ Xx10 @ Xx6 )
            | ( G @ Xx10 @ Xx7 )
            | ( G @ Xx10 @ Xx8 )
            | ( G @ Xx10 @ Xx9 )
            | ( G @ Xx11 @ Xx0 )
            | ( G @ Xx11 @ Xx1 )
            | ( G @ Xx11 @ Xx2 )
            | ( G @ Xx11 @ Xx3 )
            | ( G @ Xx11 @ Xx4 )
            | ( G @ Xx11 @ Xx5 )
            | ( G @ Xx11 @ Xx6 )
            | ( G @ Xx11 @ Xx7 )
            | ( G @ Xx11 @ Xx8 )
            | ( G @ Xx11 @ Xx9 )
            | ( G @ Xx11 @ Xx10 )
            | ( G @ Xx12 @ Xx0 )
            | ( G @ Xx12 @ Xx1 )
            | ( G @ Xx12 @ Xx2 )
            | ( G @ Xx12 @ Xx3 )
            | ( G @ Xx12 @ Xx4 )
            | ( G @ Xx12 @ Xx5 )
            | ( G @ Xx12 @ Xx6 )
            | ( G @ Xx12 @ Xx7 )
            | ( G @ Xx12 @ Xx8 )
            | ( G @ Xx12 @ Xx9 )
            | ( G @ Xx12 @ Xx10 )
            | ( G @ Xx12 @ Xx11 )
            | ( G @ Xx13 @ Xx0 )
            | ( G @ Xx13 @ Xx1 )
            | ( G @ Xx13 @ Xx2 )
            | ( G @ Xx13 @ Xx3 )
            | ( G @ Xx13 @ Xx4 )
            | ( G @ Xx13 @ Xx5 )
            | ( G @ Xx13 @ Xx6 )
            | ( G @ Xx13 @ Xx7 )
            | ( G @ Xx13 @ Xx8 )
            | ( G @ Xx13 @ Xx9 )
            | ( G @ Xx13 @ Xx10 )
            | ( G @ Xx13 @ Xx11 )
            | ( G @ Xx13 @ Xx12 )
            | ( G @ Xx14 @ Xx0 )
            | ( G @ Xx14 @ Xx1 )
            | ( G @ Xx14 @ Xx2 )
            | ( G @ Xx14 @ Xx3 )
            | ( G @ Xx14 @ Xx4 )
            | ( G @ Xx14 @ Xx5 )
            | ( G @ Xx14 @ Xx6 )
            | ( G @ Xx14 @ Xx7 )
            | ( G @ Xx14 @ Xx8 )
            | ( G @ Xx14 @ Xx9 )
            | ( G @ Xx14 @ Xx10 )
            | ( G @ Xx14 @ Xx11 )
            | ( G @ Xx14 @ Xx12 )
            | ( G @ Xx14 @ Xx13 ) ) ) ) )).

%------------------------------------------------------------------------------
